<?php
/*******************************************************************************
* Image cache plugin extension                                                 *
* (C) Copyright Y2K Software s.a.s., Italy 2006 - All Rights Reserved          *
* ---------------------------------------------------------------------------- *
* Saves images between the [IMG] and [/IMG] tags to file system                *
* Requires a full access folder at <forumhome>/imgcache/                       *
*******************************************************************************/
















// Get cache ID (collision-free) -----------------------------------------------
function GetCacheID()
{
    global $db;
















    $SQL = "INSERT INTO " . TABLE_PREFIX . "y2ksw_imgcache (ID) VALUES (0)";
    $db->query_write($SQL);
















    return $db->insert_id();
}
















function CacheImages($message_body, $old_message, $forum_home)
{
    // Occurrance check --------------------------------------------------------
    $n = 0;
    $pos_end = -1;
    for(;;)
    {
        $pos_start = strpos(strtolower($message_body), '[img]', $pos_end + 1);
        if($pos_start === FALSE)
        {
            break;
        }
        
        $pos_end = strpos(strtolower($message_body), '[/img]', $pos_start + 1);
        if($pos_end === FALSE)
        {
            break;
        }
    
        // Adjust pointers
        $pos_start += 5;
        $pos_end--;
    
        // Add reference to array if valid comparison
        $files[$n]['url'] = substr($message_body, $pos_start, $pos_end - $pos_start + 1);
        $n++;
    }
















    // If there was no occurrance, exit from function --------------------------
    if(!$n)
    {
        return $old_message;
    }
















    // Don't change already cached files ---------------------------------------
    for($i = 0; $i < $n; $i++)
    {
        if(strpos($files[$i]['url'], $forum_home . 'imgcache/') !== FALSE)
        {
            $files[$i]['url'] = '';
        }
    }
















    // Discard duplicates ------------------------------------------------------
    for($i = 0; $i < $n; $i++)
    {
        $a = $files[$i]['url'];
        if($a)
        {
            for($j = $i + 1; $j < $n; $j++)
            {
                if($files[$j]['url'] == $a)
                {
                    $files[$j]['url'] = '';
                }
            }
        }
    }
















    // Get contents ------------------------------------------------------------
    for($i = 0; $i < $n; $i++)
    {
        // Get content if url is valid
        if(@getimagesize($files[$i]['url']))
        {
            // A localhost file will fail, also not existing references
            $files[$i]['content'] = @file_get_contents($files[$i]['url']);
        }
    }
















    // Save file contents to file system ---------------------------------------
    for($i = 0; $i < $n; $i++)
    {
        // Write if contents are available
        $k = strlen($files[$i]['content']);
        if($k)
        {
            // Get unique cache ID (collision-free)
            $id = GetCacheID();
            // Create filename
            $ext = substr($files[$i]['url'], strrpos($files[$i]['url'], '.') + 1);
$f = 'imgcache/' . sprintf('%d', $id) . '.'.$ext;

            // Open file
            $hFile = @fopen($f, 'wb');
            if($hFile)
            {
                // Write file contents
                $m = 0;
                $m = @fwrite($hFile, $files[$i]['content'], $k);
                // Close file
                fclose($hFile);
                // Free some memory
                $files[$i]['content'] = '';
                // Replace URL's if successfully written
                if($m == $k)
                {
                    $old_url = $files[$i]['url'];
                    $new_url = $forum_home . $f;
                    $old_message = str_replace($old_url, $new_url, $old_message);
                }
            }
        }
    }
















    return $old_message;
}
?>






